#include <avr/io.h>
#include <util/delay.h>

void init()
{
    PORTB &= ~_BV(PB5);
    DDRB |= _BV(PB5);
}

inline void ledOn()
{
    PORTB |= _BV(PB5);
}

inline void ledOff()
{
    PORTB &= ~_BV(PB5);
}

inline void ledCycle(int onMs, int offMs)
{
    ledOn();
    _delay_ms(onMs);
    ledOff();
    _delay_ms(offMs);
}

int main()
{
    init();
    while (1)
    {
		ledCycle(200, 200);
		ledCycle(200, 200);
		ledCycle(200, 200);
		ledCycle(200, 500);
    }
}

