#include <avr/io.h>
#include <util/delay.h>

void init()
{
    PORTB &= ~_BV(PB5);
    DDRB |= _BV(PB5);
}

inline void ledOn()
{
    PORTB |= _BV(PB5);
}

inline void ledOff()
{
    PORTB &= ~_BV(PB5);
}

template <int ms, bool on>
void ledHalfCycle()
{
    if (on) {
	ledOn();
    } else {
	ledOff();
    }
    _delay_ms(ms);
}

template <int onMs, int offMs>
void ledCycle()
{
    ledHalfCycle<onMs, true>();
    ledHalfCycle<offMs, false>();
}

int main()
{
    init();
    while (1)
    {
	ledCycle<200, 200>();
	ledCycle<200, 200>();
	ledCycle<200, 200>();
	ledCycle<200, 500>();
    }
}

