#include <avr/io.h>
#include <util/delay1.hh>

void init()
{
    PORTB &= ~_BV(PB5);
    DDRB |= _BV(PB5);
}

inline void ledOn()
{
    PORTB |= _BV(PB5);
}

inline void ledOff()
{
    PORTB &= ~_BV(PB5);
}

template <int ms>
void ledHalfCycle(bool on)
{
    if (on) {
	ledOn();
    } else {
	ledOff();
    }
    delay_ms(ms);
}

template <int onMs, int offMs>
void ledCycle()
{
    ledHalfCycle<onMs>(true);
    ledHalfCycle<offMs>(false);
}

int main()
{
    init();
    while (1)
    {
	ledCycle<200, 200>();
	ledCycle<200, 200>();
	ledCycle<200, 200>();
	ledCycle<200, 500>();
    }
}

