#include "gpio.hh"
#include <util/delay.hh>

GpioOut led(GPIO(B, 5), false);

template <int ms>
void ledHalfCycle(bool on)
{
    led.set(on);
    delay_ms(ms);
}

template <int onMs, int offMs>
void ledCycle()
{
    ledHalfCycle<onMs>(true);
    ledHalfCycle<offMs>(false);
}

int main()
{
    while (1)
    {
	ledCycle<200, 200>();
	ledCycle<200, 200>();
	ledCycle<200, 200>();
	ledCycle<200, 500>();
    }
}

