#include "gpio.hh"
#include <util/delay.hh>

template <int ms>
void ledHalfCycle(GpioOut &led, bool on)
{
    led.set(on);
    delay_ms(ms);
}

template <int onMs, int offMs>
void ledCycle(GpioOut &led)
{
    ledHalfCycle<onMs>(led, true);
    ledHalfCycle<offMs>(led, false);
}

int main()
{
    GpioOut led(GPIO(B, 5), false);

    while (1)
    {
	ledCycle<200, 200>(led);
	ledCycle<200, 200>(led);
	ledCycle<200, 200>(led);
	ledCycle<200, 500>(led);
    }
}

