#ifndef GPIO_HH_SEEN
#define GPIO_HH_SEEN

#include <avr/io.h>

struct GpioDef
{
    volatile uint8_t *portAddr;
    volatile uint8_t *dirAddr;
    volatile uint8_t *pin_addr;
    uint8_t bit;
};

#define GPIO(port, bit) GpioDef({&PORT##port, &DDR##port, &PIN##port, bit})

class GpioOut
{
public:
    GpioOut(GpioDef def, bool initState)
	: port(def.portAddr)
	, bitVal(_BV(def.bit))
    {
	set(initState);
	*def.dirAddr |= bitVal;
    }

    void set(bool state)
    {
	if (state)
	{
	    *port |= bitVal;
	} else {
	    *port &= ~bitVal;
	}
    }

private:
    volatile uint8_t *port;
    uint8_t bitVal;
};

class GpioIn
{
public:
    GpioIn(GpioDef def)
	: port(def.portAddr)
	, bitVal(_BV(def.bit))
    {
	*def.dirAddr &= ~bitVal;
    }

    bool get()
    {
	return *port &= bitVal;
    }

private:
    volatile uint8_t *port;
    uint8_t bitVal;
};
#endif /* GPIO_HH_SEEN */
