#ifndef UTIL_DELAY1_HH_SEEN
#define UTIL_DELAY1_HH_SEEN

#include <inttypes.h>

#ifndef F_CPU
#error "F_CPU not defined (required for delay_ms())"
#endif

namespace {
constexpr double _delay_1ms = (F_CPU) / 4e3;
constexpr double _delay_100us = ((F_CPU) / 4e3) / 10;
} // unnamed namespace

struct _delay_ms_ticks
{
    constexpr _delay_ms_ticks(double _ms)
	: _loops(_delay_1ms * _ms > 65535 ? _ms * 10 : 1)
	, _ticks(_delay_1ms * _ms > 65535 ? _delay_100us : (_delay_1ms * _ms < 1.0) ? 1 : _delay_1ms * _ms)
	{}
    uint16_t _loops;
    uint16_t _ticks;
};

void delay_ms(_delay_ms_ticks);
#endif /* UTIL_DELAY1_HH_SEEN */
